# import libraries
import numpy as np
from matplotlib import pyplot as plt

# Loading results files
dirdyn_q          = np.loadtxt("resultsR/dirdyn_q.res")
dirdyn_qd          = np.loadtxt("resultsR/dirdyn_qd.res")
dirdyn_qdd          = np.loadtxt("resultsR/dirdyn_qdd.res")

# plotting
f, axarr = plt.subplots(3, sharex=True, num='C')

axarr[0].set_ylabel('q')
axarr[0].plot(dirdyn_q[:,0], dirdyn_q[:,1])

axarr[1].plot(dirdyn_qd[:,0], dirdyn_qd[:,1])

axarr[2].set_xlabel('time [s]')
axarr[2].plot(dirdyn_qdd[:,0], dirdyn_qdd[:,1])


plt.subplots_adjust(left=0.15, bottom=0.07, right=0.85, top=0.96, wspace=None, hspace=0.20)

#plt.title("Results Five-Link Suspension")
plt.show()
